<?php
/* --------------------------------------------------------------
   SeoTagsServiceProvider.php 2025-09-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);


namespace Gambio\Admin\Modules\SeoTags;

use Gambio\Admin\Modules\SeoTags\Decorator\CategoryPageNoIndexKeysDecorator;
use Gambio\Admin\Modules\SeoTags\Decorator\SeoTagsDataProviderDecorator;
use Gambio\Admin\Modules\SeoTags\Interfaces\SeoTagsDataProviderDecoratorInterface;
use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Configuration\Services\ConfigurationService;
use SeoTagsDataProvider;

class SeoTagsServiceProvider extends AbstractServiceProvider
{
    
    public function provides(): array
    {
        return [
          SeoTagsService::class,
          SeoTagsDataProviderDecorator::class,
          CategoryPageNoIndexKeysDecorator::class
        ];
    }
    
    
    public function register(): void
    {
        $this->application->registerShared(SeoTagsService::class)
            ->addArgument(ConfigurationService::class)
        ;
        
        $this->application->registerShared(SeoTagsDataProviderDecoratorInterface::class, SeoTagsDataProviderDecorator::class);
        
        $this->application->registerShared(CategoryPageNoIndexKeysDecorator::class);
        
        
        
    }
}